/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GlowstoneSpikesFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150424_aL;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    int minRadius = 2;
    int maxRadius = 3;
    int minHeight = 4;
    int maxHeight = 11;

    public GlowstoneSpikesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos startPos, NoFeatureConfig p_212245_5_) {
        int randRadius = this.minRadius + rand.nextInt(this.maxRadius - this.minRadius);
        int height = this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        for (int x = 0; x <= randRadius - 1; ++x) {
            for (int z = 0; z <= randRadius - 1; ++z) {
                if (this.placeOn.matches(world, startPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        BlockPos pos = startPos.func_177984_a();
        for (int y = 0; y < height - 1; ++y) {
            int radius = randRadius * (height - y) / height + 1;
            int radiusStart = MathHelper.func_76143_f((double)(0.25 - (double)radius / 2.0));
            int radiusEnd = MathHelper.func_76128_c((double)(0.25 + (double)radius / 2.0));
            for (int x = radiusStart; x <= radiusEnd; ++x) {
                for (int z = radiusStart; z <= radiusEnd; ++z) {
                    if (!this.replace.matches(world, pos.func_177982_a(x, y, z))) continue;
                    world.func_180501_a(pos.func_177982_a(x, y, z), Blocks.field_150426_aN.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

