/*
 * Decompiled with CFR 0.152.
 */
package tfar.simpletrophies.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import tfar.simpletrophies.SimpleTrophies;
import tfar.simpletrophies.client.tesr.RenderItemStackSimpleTrophy;
import tfar.simpletrophies.client.tesr.RenderTileSimpleTrophy;
import tfar.simpletrophies.client.tesr.TrophyModelWrapper;
import tfar.simpletrophies.common.config.TrophyConfig;
import tfar.simpletrophies.common.etc.TrophyHelpers;
import tfar.simpletrophies.common.tile.TileSimpleTrophy;

@Mod.EventBusSubscriber(modid="simple_trophies", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientGameEvents {
    private static long ticksInGame = 0L;
    private static boolean paused = false;
    private static float lastNonPausedPartialTicks = 0.0f;
    public static final ModelResourceLocation[] modelResourceLocations = new ModelResourceLocation[]{new ModelResourceLocation("simple_trophies:classic", "inventory"), new ModelResourceLocation("simple_trophies:gold", "inventory"), new ModelResourceLocation("simple_trophies:neon", "inventory")};

    @SubscribeEvent
    public static void models(ModelRegistryEvent e) {
        if (!((Boolean)TrophyConfig.ClientConfig.NO_TEISR.get()).booleanValue()) {
            // empty if block
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileSimpleTrophy.class, (TileEntityRenderer)new RenderTileSimpleTrophy());
    }

    @SubscribeEvent
    public static void blockColors(ColorHandlerEvent.Block e) {
        BlockColors bc = e.getBlockColors();
        IBlockColor iBlockColor = (state, world, pos, tintIndex) -> {
            if (world == null || pos == null || tintIndex != 0) {
                return 0xFFFFFF;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileSimpleTrophy) {
                TileSimpleTrophy trophy = (TileSimpleTrophy)tile;
                return TrophyHelpers.getCombinedColor(trophy);
            }
            return 0xFFFFFF;
        };
        bc.func_186722_a(iBlockColor, SimpleTrophies.RegistryEvents.trophy_blocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void itemColors(ColorHandlerEvent.Item e) {
        ItemColors ic = e.getItemColors();
        IItemColor iItemColor = (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            return TrophyHelpers.getCombinedColor(stack);
        };
        ic.func_199877_a(iItemColor, (IItemProvider[])SimpleTrophies.RegistryEvents.trophy_blocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            Screen ui = mc.field_71462_r;
            if (mc.func_71356_B() && ui != null && ui.isPauseScreen() && mc.func_71401_C() != null && !mc.func_71401_C().func_71344_c()) {
                paused = true;
            } else {
                ++ticksInGame;
                paused = false;
            }
        }
    }

    @SubscribeEvent
    public static void modelbake(ModelBakeEvent e) {
        Map modelResourceLocationIBakedModelMap = e.getModelRegistry();
        for (int i = 0; i < 3; ++i) {
            TrophyModelWrapper model = new TrophyModelWrapper((IBakedModel)modelResourceLocationIBakedModelMap.get(modelResourceLocations[i]));
            RenderItemStackSimpleTrophy.teisrs.get(i).setModel(model);
            modelResourceLocationIBakedModelMap.put(modelResourceLocations[i], model);
        }
    }

    public static long getTicksInGame() {
        return ticksInGame;
    }

    public static float getPauseAdjustedPartialTicks() {
        if (paused) {
            return lastNonPausedPartialTicks;
        }
        lastNonPausedPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        return lastNonPausedPartialTicks;
    }

    public static float getPauseAdjustedTicksAndPartialTicks() {
        return (float)ClientGameEvents.getTicksInGame() + ClientGameEvents.getPauseAdjustedPartialTicks();
    }
}

