/*
 * Decompiled with CFR 0.152.
 */
package tfar.simpletrophies.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfar.simpletrophies.common.etc.TrophyHelpers;
import tfar.simpletrophies.common.tile.TileSimpleTrophy;

public class BlockSimpleTrophy
extends Block {
    public static final String KEY_NAME = "TrophyName";
    public static final String KEY_ITEM = "TrophyItem";
    public static final String KEY_COLOR_RED = "TrophyColorRed";
    public static final String KEY_COLOR_GREEN = "TrophyColorGreen";
    public static final String KEY_COLOR_BLUE = "TrophyColorBlue";
    public static final String KEY_VARIANT = "TrophyVariant";
    public static final String KEY_EARNED_AT = "TrophyEarnedAt";
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public BlockSimpleTrophy(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSimpleTrophy();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!player.func_184812_l_()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleTrophy) {
            TileSimpleTrophy trophy = (TileSimpleTrophy)tile;
            int averageColor = -1;
            if (averageColor == -1) {
                trophy.displayedStack = player.func_184586_b(hand).func_77946_l();
            } else {
                trophy.displayedColorRed = (averageColor & 0xFF0000) >> 16;
                trophy.displayedColorGreen = (averageColor & 0xFF00) >> 8;
                trophy.displayedColorBlue = averageColor & 0xFF;
            }
            BlockState hahaYes = world.func_180495_p(pos);
            world.func_184138_a(pos, hahaYes, hahaYes, 2);
            trophy.func_70296_d();
            return true;
        }
        return false;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleTrophy) {
            BlockSimpleTrophy.func_180635_a((World)world, (BlockPos)pos, (ItemStack)TrophyHelpers.createItemStackFromTile(pos, (IBlockReader)world, this));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return TrophyHelpers.createItemStackFromTile(pos, world, this);
    }
}

